import matplotlib as mpl

# # # # # # # # # # # # # # # # # # # # # # # # 
# This script sets the default parameters for
# matplotlib to produce nice figures, e.g.
# font types, line widths, ...
# # # # # # # # # # # # # # # # # # # # # # # # 

name = "Figure Settings for Matplotlib"

cm2inch = lambda x: 0.393700787 * x


#for plos
fig_width = dict(
    one_col = cm2inch(7.),
    two_col = cm2inch(16.)
    )

font_panellabel = dict(fontweight='bold', fontsize=12, ha='left')

# # # # # 
# OLD VERSION
# # # # #
if mpl.__version__ == "1.0.1":
    config = {
        'axes' : dict(labelsize=8, titlesize=8, linewidth=0.5),
        #'figure' : dict(dpi=200, figsize=[fig_width['one_col'], 0.75*fig_width['one_col']], facecolor='white'),
        'figure' : dict(dpi=118, figsize=[fig_width['two_col'], 0.75*fig_width['two_col']], facecolor='white'),
        'figure.subplot' : dict(left=0.15, bottom=0.15, right=0.97, top=0.97),
        'font' : {'family' : 'sans-serif', 'size' : 8, 'weight' : 'normal',
                'sans-serif' : ['Arial', 'LiberationSans-Regular', 'FreeSans']},
        'image' : dict(cmap='RdBu_r' , interpolation='nearest'),
        'legend' : dict(fontsize=8, axespad=0.03, borderpad=0.3),
        'lines' : dict(linewidth=0.5),
        'xtick' : dict(labelsize=8),
        'xtick.major' : dict(size=2, pad=2),
        'ytick' : dict(labelsize=8),
        'ytick.major' : dict(size=2, pad=2),
        'savefig' : dict(dpi=300)
        }
# # # # # 
# NEWER VERSIONS
# # # # #
else:
    config = {
        'axes' : dict(labelsize=8, titlesize=8, linewidth=0.5),
        #'figure' : dict(dpi=200, figsize=[fig_width['one_col'], 0.75*fig_width['one_col']], facecolor='white'),
        'figure' : dict(dpi=118, figsize=[fig_width['two_col'], 0.75*fig_width['two_col']], facecolor='white'),
        'figure.subplot' : dict(left=0.15, bottom=0.15, right=0.97, top=0.97),
        'font' : {'family' : 'sans-serif', 'size' : 8, 'weight' : 'normal',
                'sans-serif' : ['Arial', 'LiberationSans-Regular', 'FreeSans']},
        'image' : dict(cmap='RdBu_r' , interpolation='nearest'),
        'legend' : dict(fontsize=8, borderaxespad=0.03, borderpad=0.3),
        'lines' : dict(linewidth=0.5),
        'xtick' : dict(labelsize=8),
        'xtick.major' : dict(size=2, pad=2),
        'ytick' : dict(labelsize=8),
        'ytick.major' : dict(size=2, pad=2),
        'savefig' : dict(dpi=300)
        }



print "\n\t * * * Importing '%s' * * *\n" % name

for key,val in config.iteritems():
    s = ""
    for k,v in val.iteritems():
        s += k + "=%s, " % str(v)
    print "  > Set '%s' to %s" % (key, s[:-2])
    mpl.rc(key, **val)

print '\n\n'
